(() => {
    'use strict';
    const script = document.currentScript;
    const param = PluginManagerEx.createParameter(script);
    if (!param.GaugeList) {
        param.GaugeList = [];
    }

    const _Scene_Base_create    = Scene_Base.prototype.create;
    Scene_Base.prototype.create = function() {
        _Scene_Base_create.apply(this, arguments);
        if (!(this instanceof Scene_Map)) {
            this.createExtraGauges();
        }
    };

    // 場所移動時に画像キャッシュが破棄される仕様のためマップ画面ではキャッシュ破棄後にゲージを作成する
    const _Scene_Map_create = Scene_Map.prototype.create;
    Scene_Map.prototype.create = function() {
        _Scene_Map_create.apply(this, arguments);
        this.createExtraGauges();
    };

    Scene_Base.prototype.createExtraGauges = function() {
        this._extraGauges = this.findExtraGaugeList().map(data => {
            return new Sprite_ExtraGaugeContainer(data, data.Detail || {}, data.Layout || {});
        });
    };

    const _Scene_Base_start    = Scene_Base.prototype.start;
    Scene_Base.prototype.start = function() {
        _Scene_Base_start.apply(this, arguments);
        this.addExtraGauge();
    };

    Scene_Base.prototype.addExtraGauge = function() {
        if (this._extraGaugesAdd) {
            return;
        }
        this._extraGauges.forEach(extraGauge => {
            this.addChildExtraGauge(extraGauge);
        });
        this._extraGaugesAdd = true;
    };

    Scene_Base.prototype.addChildExtraGauge = function(extraGauge) {
        const parentName = extraGauge.getParentWindowName();
        if (parentName && this._windowLayer) {
            const win = this._windowLayer.children.find(window =>
                window instanceof Window && window.findWindowClassName() === parentName);
            if (win) {
                win.addChild(extraGauge);
            } else {
                PluginManagerEx.throwError('Window is not found : ' + parentName, script);
            }
        } else if (param.Priority > 0 && !!this._spriteset) {
            this._spriteset.addChildExtraGauge(extraGauge);
        } else {
            this.addChild(extraGauge);
        }
    };

    Spriteset_Base.prototype.addChildExtraGauge = function(extraGauge) {
        let index = this.getChildIndex(this._pictureContainer);
        if (param.Priority === 2) {
            index++;
        }
        this.addChildAt(extraGauge, index);
    };

    Scene_Base.prototype.findExtraGaugeList = function() {
        const currentSceneName = PluginManagerEx.findClassName(this);
        return (param.GaugeList || []).filter(function(data) {
            return data.SceneName === currentSceneName;
        }, this);
    };

    const _Sprite_Gauge_initialize = Sprite_Gauge.prototype.initialize;
    Sprite_Gauge.prototype.initialize = function(data, detail, layout) {
        if (data) {
            this._data = data;
            this._detail = detail;
            this._layout = layout;
        }
        _Sprite_Gauge_initialize.apply(this, arguments);
    };

    Window.prototype.findWindowClassName = function() {
        const className = PluginManagerEx.findClassName(this);
        // for SceneCustomMenu.js
        if (this._data?.Id) {
            return this._data.Id;
        } else {
            return className;
        }
    };

    const _Sprite_Battler_updatePosition = Sprite_Battler.prototype.updatePosition;
    Sprite_Battler.prototype.updatePosition = function() {
        _Sprite_Battler_updatePosition.apply(this, arguments);
        if (this._battler) {
            this._battler.updateSpritePosition(this);
        }
    };

    Game_Battler.prototype.updateSpritePosition = function(sprite) {
        this._imageX = sprite.x;
        this._imageY = sprite.y;
    };

    Game_Battler.prototype.findImageX = function() {
        return this._imageX || 0;
    };

    Game_Battler.prototype.findImageY = function() {
        return this._imageY || 0;
    };

    Game_Actor.prototype.currentLevelUpExp = function() {
        return this.nextLevelExp() - this.currentLevelExp();
    };

    Game_Actor.prototype.currentLevelGetExp = function() {
        return this.currentExp() - this.currentLevelExp();
    };

    /**
     * Sprite_ExtraGaugeContainer
     * 追加ゲージとピクチャを含むコンテナです。
     */
    class Sprite_ExtraGaugeContainer extends Sprite {
        constructor(data, detail, layout) {
            super();
            this._data = data;
            this._detail = detail;
            this._layout = layout;
            this.create();
        }

        getParentWindowName() {
            return this._layout.ParentWindow;
        }

        create() {
            this._gauge = new Sprite_ExtraGauge(this._data, this._detail, this._layout);
            this._lower = this.createPicture(this._data.LowerPicture);
            this.addChild(this._gauge);
            this._upper = this.createPicture(this._data.UpperPicture);
            this.setupPosition();
            this.update();
        }

        setupPosition() {
            this.x = this._gauge.findLayoutValue(this._layout.x);
            this.y = this._gauge.findLayoutValue(this._layout.y);
            this._baseX = this.x;
            this._baseY = this.y;
            if (this._layout.Mirror) {
                this.scale.x = -1;
            }
            if (this._lower && this._detail.GaugeBackHidden) {
                this._gauge.syncWithPicture(this._lower);
            }
        }

        syncBattler() {
            const battler = this._gauge.findLinkBattler();
            this.x = this._baseX + battler.findImageX();
            this.y = this._baseY + battler.findImageY();
        }

        syncCharacter() {
            const id = this._layout.linkCharacter;
            const character = id < 0 ? $gamePlayer : $gameMap.event(id);
            if (character) {
                this.x = this._baseX + character.screenX();
                this.y = this._baseY + character.screenY();
            }
        }

        update() {
            this.updateVisibly();
            super.update();
            if (this._layout.realTime) {
                this.setupPosition();
            }
            if (!!this._gauge.findLinkBattler()) {
                this.syncBattler();
            }
            if (this._layout.linkCharacter && !!$dataMap) {
                this.syncCharacter();
            }
            this.updateOpacity();
            this.updateFullSwitch();
            this._gauge.updateBattler();
        }

        updateVisibly() {
            this.visible = this.isVisible();
        }

        updateOpacity() {
            if (this._data.OpacityVariable) {
                this.opacity = $gameVariables.value(this._data.OpacityVariable);
            }
        }

        updateFullSwitch() {
            const id = this._detail.FullSwitchId;
            if (id > 0) {
                $gameSwitches.setValue(id, this._gauge.isFull());
            }
        }

        isVisible() {
            return !this._data.SwitchId || $gameSwitches.value(this._data.SwitchId);
        }

        createPicture(pictureData) {
            if (!pictureData || !pictureData.FileName) {
                return null;
            }
            const sprite = new Sprite();
            sprite.bitmap = ImageManager.loadPicture(pictureData.FileName);
            this._gauge.setSpriteOrigin(sprite);
            sprite.x = pictureData.OffsetX || 0;
            sprite.y = pictureData.OffsetY || 0;
            this.addChild(sprite);
            return sprite;
        }
    }
    window.Sprite_ExtraGaugeContainer = Sprite_ExtraGaugeContainer;

    /**
     * Sprite_ExtraGauge
     * 追加ゲージを扱うクラスです。
     */
    class Sprite_ExtraGauge extends Sprite_Gauge {
        constructor(data, detail, layout) {
            super(data, detail, layout);
            this.setup(this.findBattler(), this._detail.GaugeColorPreset);
            this.setupPosition();
            if (this._detail.GaugeImage) {
                this.setupImage();
            }
            if (this._detail.GaugeBackHidden) {
                this.bitmap.fillRect = new Function();
            }
        }

        setupImage() {
            const gauge = new Sprite();
            gauge.bitmap = ImageManager.loadPicture(this._detail.GaugeImage);
            gauge.x = -this.width / 2 + this.gaugeX();
            gauge.y = -this.gaugeHeight() / 2 + (this.height - this.gaugeHeight()) / 2;
            if (this._detail.ScaleAutoAdjust) {
                gauge.bitmap.addLoadListener(() => {
                    gauge.scale.x = (this.width - this.gaugeX() - this.gaugeEndX()) / gauge.width;
                    gauge.scale.y = this.gaugeHeight() / gauge.height;
                });
            }
            this._gaugeImage = gauge;
            this.bitmap.gradientFillRect = new Function();
            this.addChild(gauge);
        }

        updateBattler() {
            if (this._menuActor) {
                this._battler = $gameParty.menuActor();
            }
        }

        findBattler() {
            const battlerData = this._data.Battler;
            if (!battlerData || !battlerData.Type) {
                return $gameParty.members()[0];
            }
            const methodName = `findBattler${battlerData.Type}`;
            if (this[methodName]) {
                return this[methodName](battlerData);
            } else {
                return null;
            }
        }

        setSpriteOrigin(sprite) {
            if (this._layout.originX === 'left') {
                sprite.anchor.x = 0;
            } else if (this._layout.originX === 'right') {
                sprite.anchor.x = 1;
            } else {
                sprite.anchor.x = 0.5;
            }
            if (this._layout.originY === 'top') {
                sprite.anchor.y = 0;
            } else if (this._layout.originY === 'bottom') {
                sprite.anchor.y = 1;
            } else {
                sprite.anchor.y = 0.5;
            }
        }

        findLinkBattler() {
            if (this._data.Battler?.Type && this._data.Battler?.LinkPosition) {
                return this.findBattler();
            } else {
                return null;
            }
        }

        findBattlerActorId(battlerData) {
            return $gameActors.actor(battlerData.ActorId);
        }

        findBattlerMenuActor(battlerData) {
            this._menuActor = true;
            return $gameParty.menuActor();
        }

        findBattlerPartyIndex(battlerData) {
            return $gameParty.members()[battlerData.Index];
        }

        findBattlerEnemyId(battlerData) {
            const id = battlerData.EnemyId;
            const enemy = $gameTroop.members().find(battler => battler.enemyId() === id);
            return enemy || new Game_Enemy(battlerData.EnemyId, 0, 0);
        }

        findBattlerTroopIndex(battlerData) {
            return $gameTroop.members()[battlerData.Index];
        }

        updateBitmap() {
            const visible = this.parent ? this.parent.isVisible() : false;
            if (visible) {
                if (!this._prevVisible) {
                    this._value = this._targetValue;
                    this._maxValue = this._targetMaxValue;
                }
                super.updateBitmap();
            }
            this._prevVisible = visible;
        }

        updateFlashing() {
            if (!this._detail.FlashIfFull) {
                return;
            }
            if (this.isFull()) {
                this._flashingCount++;
                if (this._flashingCount % 20 < 10) {
                    this.setBlendColor(this.flashingColor1());
                } else {
                    this.setBlendColor(this.flashingColor2());
                }
            } else {
                this.setBlendColor([0, 0, 0, 0]);
            }
        }

        flashingColor1() {
            return [255, 255, 255, 96];
        }

        flashingColor2() {
            return [255, 255, 255, 64];
        }

        isFull() {
            return this._value >= this._maxValue;
        }

        setupPosition() {
            this.setSpriteOrigin(this);
            if (this._layout.Vertical) {
                this.rotation = (270 * Math.PI) / 180;
            }
        }

        syncWithPicture(sprite) {
            if (!this._gaugeImage) {
                return;
            }
            sprite.bitmap.addLoadListener(() => {
                this._gaugeImage.x = sprite.x - sprite.anchor.x * sprite.width;
                this._gaugeImage.y = sprite.y - sprite.anchor.y * sprite.height;
            });
        }

        bitmapWidth() {
            return this.findLayoutValue(this._layout.width) || super.bitmapWidth();
        }

        bitmapHeight() {
            return this.findLayoutValue(this._layout.height) || super.bitmapHeight();
        }

        textHeight() {
            return this.bitmapHeight();
        }

        gaugeHeight() {
            return this.findLayoutValue(this._layout.GaugeHeight) || this.bitmapHeight();
        }

        gaugeX() {
            return this.findLayoutValue(this._layout.GaugeX) || 0;
        }

        gaugeEndX() {
            return this.findLayoutValue(this._layout.GaugeEndX) || 0;
        }

        drawGaugeRect(x, y, width, height) {
            super.drawGaugeRect(x, y, width - this.gaugeEndX(), height);
            if (this._gaugeImage) {
                this.drawGaugeImage();
            }
        }

        drawGaugeImage() {
            const gauge = this._gaugeImage;
            gauge.bitmap.addLoadListener(() => {
                const rate = this.gaugeRate();
                gauge.setFrame(0, 0, gauge.bitmap.width * rate, gauge.bitmap.height);
            });
        }

        findLayoutValue(value) {
            if (isNaN(value)) {
                try {
                    const width = $dataSystem.advanced.uiAreaWidth;
                    const height = $dataSystem.advanced.uiAreaHeight;
                    return eval(value);
                } catch (e) {
                    console.error(e);
                    return 0;
                }
            } else {
                return value;
            }
        }

        currentValue() {
            const value = this.findValue(this._data.CurrentMethod);
            if (!isFinite(value)) {
                PluginManagerEx.throwError(`Invalid current value[${value}] id[${this._data.Id}]`, script);
            }
            return value;
        }

        currentMaxValue() {
            const value = Math.max(this.findValue(this._data.MaxMethod), 1);
            if (!isFinite(value)) {
                PluginManagerEx.throwError(`Invalid current max value[${value}] id[${this._data.Id}]`, script);
            }
            return value;
        }

        findValue(method) {
            if (!method) {
                return 0;
            } else if (method.VariableId) {
                return $gameVariables.value(method.VariableId)
            } else if (method.Script) {
                const battler = this._battler;
                if (!battler) {
                    return 0;
                }
                const meta = battler.isActor() ? battler.actor().meta : battler.enemy().meta;
                try {
                    return eval(method.Script);
                } catch (e) {
                    console.error(e);
                    return 0;
                }
            } else {
                return method.FixedValue;
            }
        }

        label() {
            return this._detail.Label || '';
        }

        labelY() {
            const y = this._detail.LabelY;
            return isFinite(y) ? y : super.labelY();
        }

        iconIndex() {
            return this._detail.IconIndex || 0;
        }

        labelColor() {
            return this.findColor(this.findLabelFont().Color, super.labelColor());
        }

        labelOutlineColor() {
            return this.findColor(this.findLabelFont().OutlineColor, super.labelOutlineColor());
        }

        labelOutlineWidth() {
            return this.findLabelFont().OutlineWidth || super.labelOutlineWidth();
        }

        labelFontFace() {
            return this.findLabelFont().Face || super.labelFontFace();
        }

        labelFontSize() {
            return this.findLabelFont().Size || super.labelFontSize();
        }

        findLabelFont() {
            return this._detail.LabelFont || {};
        }

        valueColor() {
            return this.findColor(this.findValueFont().Color, super.valueColor());
        }

        valueOutlineColor() {
            return this.findColor(this.findValueFont().OutlineColor, super.valueOutlineColor());
        }

        valueOutlineWidth() {
            return this.findValueFont().OutlineWidth || super.valueOutlineWidth();
        }

        valueFontFace() {
            return this.findValueFont().Face || super.valueFontFace();
        }

        valueFontSize() {
            return this.findValueFont().Size || super.valueFontSize();
        }

        findValueFont() {
            return this._detail.ValueFont || {};
        }

        gaugeBackColor() {
            return this.findColor(this._detail.BackColor, super.gaugeBackColor());
        }

        gaugeColor1() {
            const fullColor = this._detail.GaugeColorFullLeft;
            const color = this._detail.GaugeColorLeft;
            return this.findColor(this.isFull() ? (fullColor || color) : color, super.gaugeColor1());
        }

        gaugeColor2() {
            const fullColor = this._detail.GaugeColorFullRight;
            const color = this._detail.GaugeColorRight;
            return this.findColor(this.isFull() ? (fullColor || color) : color, super.gaugeColor2());
        }

        isValid() {
            return !!this._battler;
        }

        smoothness() {
            if (this._value <= this._targetValue) {
                return this._detail.RisingSmoothness || 1;
            } else {
                return this._detail.FallingSmoothness || 1;
            }
        }

        drawValue() {
            if (this._detail.DrawValue) {
                if (this._detail.ValueFormat) {
                    this.drawCustomValue();
                } else {
                    super.drawValue();
                }
            }
        }

        drawCustomValue() {
            const digit = this._detail.ValuePadZeroDigit || 0;
            const current = this.currentValue().padZero(digit);
            const max = this.currentMaxValue().padZero(digit);
            const text = this._detail.ValueFormat.format(current, max);
            const x = this.gaugeX();
            const width = this.bitmapWidth() - 2 - x;
            const height = this.textHeight();
            const align = this._detail.ValueAlign || 'right';
            this.setupValueFont();
            this.bitmap.drawText(text, x, 0, width, height, align);
        }

        findColor(code, defaultColor = null) {
            if (!code) {
                return defaultColor ? defaultColor : ColorManager.normalColor();
            } else if (isNaN(code)) {
                return code;
            } else {
                return ColorManager.textColor(code);
            }
        }

        drawLabel() {
            super.drawLabel();
            const icon = this.iconIndex();
            if (icon) {
                this.drawIcon(icon);
            }
        }

        drawIcon(iconIndex) {
            const bitmap = ImageManager.loadSystem("IconSet");
            const pw = ImageManager.iconWidth;
            const ph = ImageManager.iconHeight;
            const sx = (iconIndex % 16) * pw;
            const sy = Math.floor(iconIndex / 16) * ph;
            const x = this.labelOutlineWidth() / 2;
            const y = (this.bitmap.height - ph) / 2;
            this.bitmap.blt(bitmap, sx, sy, pw, ph, x, y);
        }
    }
    window.Sprite_ExtraGauge = Sprite_ExtraGauge;
})();
